#' ---
#' title: "Ανίχνευση ακραίων τιμών"
#' author: Δρ. Δημήτρης Καβρουδάκης
#' date: ""
#' output:
#'   html_document:
#'     toc: true
#'     theme: united
#'     highlight: tango
#'     toc_float: 
#'       collapsed: false
#'     number_sections: true
#'     css: /home/dimitrisk/working/Teaching/ΠΠΣ - Γεωγραφική Ανάλυση/Labs_2020/simple/style.css
#' ---
#' 

#+ echo=F, cache=F
library(knitr)
#knitr::opts_chunk$set(comment = NA, warning=F, message=F, null_prefix=T)
knitr::opts_chunk$set(comment=NA, warning=F, message=F, null_prefix=T,  prompt=F, opts.label="kill_prefix")
options(width = 300) # Console width



#' Τι είναι το IQR
#' ===
#' 
#' Το Interquartile Range (IQR) είναι το εύρος (range) μεταξύ:
#' 
#'   IQR=Q3−Q1
#'   
#'   IQR=Q3−Q1
#'   
#'   όπου:
#'   
#'   * Q1 (1ο τεταρτημόριο) = η τιμή κάτω από την οποία βρίσκεται το 25% των δεδομένων
#'     
#'   * Q3 (3ο τεταρτημόριο) = η τιμή κάτω από την οποία βρίσκεται το 75% των δεδομένων
#'
#'
#' Τι μετράει το IQR
#' 
#' Το IQR σου λέει πόσο "απλωμένα" είναι τα μεσαία 50% των δεδομένων.
#' 
#' Δεν επηρεάζεται από ακραίες τιμές (outliers), σε αντίθεση με το σύνολο των δεδομένων ή την τυπική απόκλιση.
#' 
#' Για ανίχνευση outliers — θεωρούμε ότι μια τιμή είναι ακραία όταν:
#' 
#' x<Q1−1.5×IQR ή x>Q3+1.5×IQR
#' 
#' Για ανάλυση κατανομών — ειδικά όταν δεν είναι κανονικές. Χρησιμοποιείται στα boxplots — το κουτί δείχνει Q1 έως Q3 (άρα ύψος = IQR)
#'  
#'  

#' Δεδομένα
#' ===
#' 
temps = c(
  18, 19, 21, 20, 19, 22, 21, 20, 19, 
  90,          # ύποπτα μεγάλη τιμή
  20, 21, 19, 18, 17, 16, 
  130,   # ακραία τιμή
  18, 20, 21, 19, 22
)

#' Βασικά περιγραφικά στατιστικά
#' ===
#' 
summary(temps)

mean_val   = mean(temps)
median_val = median(temps)
sd_val     = sd(temps)

#' Μέση τιμή
mean_val

#' Διάμεσος
median_val

#' Τυπική απόκλιση
sd_val



#' Ανίχνευση outliers με κανόνα IQR
#' ===
#' 
Q1       = as.numeric(quantile(temps, 0.25, type = 7))
Q3       = as.numeric(quantile(temps, 0.75, type = 7))
IQR_val  = IQR(temps, type = 7)

lower    = Q1 - 1.5 * IQR_val
upper    = Q3 + 1.5 * IQR_val


#' IQR / Τεταρτημόρια
#' 
#' Q1
Q1

#' Q3
Q3

#' IQR_val
IQR_val

#' Κάτω όριο
lower

#' Άνω όριο
upper



#' Outliers σύμφωνα με IQR
#' ===
#' 
outliers_iqr = temps[temps < lower | temps > upper]

#' Outliers (κανόνας IQR)
#' 
outliers_iqr

#' Data frame με flag για κάθε παρατήρηση
#' ===
#' 
df = data.frame(
  day  = seq_along(temps),
  temp = temps
)

df$outlier_flag = "OK"
df$outlier_flag[df$temp < lower] = "LOW"
df$outlier_flag[df$temp > upper] = "HIGH"

#' Πρώτες γραμμές του data frame
print(head(df, 15))

#' Δεύτερη μέθοδος: Z-scores
#' ===
#' 
z_scores = as.numeric(scale(temps))  # (x - mean) / sd
df$z     = z_scores

outliers_z = temps[abs(z_scores) > 3]

#' Outliers με βάση |Z| > 3:
print(outliers_z)


#' Οπτικοποίηση με boxplot (base R)
#' ===
#' 

par(mfrow = c(1, 2))  # δύο γραφήματα δίπλα-δίπλα

# (α) Απλό boxplot με επισήμανση outliers
boxplot(temps,  main = "Boxplot θερμοκρασιών", ylab = "Θερμοκρασία")
out_idx = which(temps < lower | temps > upper)
points(rep(1, length(out_idx)), temps[out_idx], col = "red", pch = 19) # Σημειώνουμε τα outliers του IQR με κόκκινα σημεία
text(rep(1, length(out_idx)), temps[out_idx], labels = temps[out_idx], pos = 3, col = "red", cex = 0.8)

# (β) Scatter per day για να δούμε πού βρίσκονται χρονικά
plot(df$day, df$temp, main = "Θερμοκρασία ανά ημέρα", xlab = "Ημέρα", ylab = "Θερμοκρασία", pch = 19)
points(df$day[df$outlier_flag == "HIGH"],  df$temp[df$outlier_flag == "HIGH"], col = "red", pch = 19, cex = 1.3) # Χρωματίζουμε τους outliers
text(df$day[df$outlier_flag == "HIGH"], df$temp[df$outlier_flag == "HIGH"], labels = df$temp[df$outlier_flag == "HIGH"], pos = 3, col = "red", cex = 0.8)
abline(h = mean_val, lty = 2, col = "gray40") # γραμμή μέσης τιμής

par(mfrow = c(1, 1))  # reset layout
