#' ---
#' title: "00-Εισαγωγή στην R για Γεωγραφική Ανάλυση"
#' author: Δρ. Δημήτρης Καβρουδάκης
#' date: ""
#' output:
#'   html_document:
#'     toc: true
#'     theme: united
#'     highlight: tango
#'     toc_float: 
#'       collapsed: true
#'     number_sections: true
#'     css: ../style.css
#' ---



#+ echo=FALSE, cache=FALSE
options(width = 1500 )
knitr::opts_chunk$set(comment = NA, warning=F, message=F, null_prefix=TRUE, prompt = F, opts.label="kill_prefix")



#' R
#' ===
#' 


#' Γενικά
#' ---
#' Η R είναι μια σύγχρονη γλώσσα προγραμματισμού η οποία σχεδιάστηκε και 
#' χρησιμοποιείται παγκοσμίως σε ακαδημαϊκό και επιχειρησιακό επίπεδο καθώς 
#' προσφέρει αυξημένες δυνατότητες υπολογιστικής ανάλυσης. Η ανάπτυξη και 
#' διάδοση της στηρίζεται στην δυνατότητα ανάπτυξης και διάθεσης πρόσθετων 
#' βιβλιοθηκών οι οποίες προσφέρουν επιπρόσθετες λειτουργίες και δυνατότητες.
#' 
#' Έτσι κάθε επιστημονικό πεδίο έχει την δυνατότητα να προσφέρει εξειδικευμένες 
#'  μεθόδους στο κεντρικό αποθετήριο βιβλιοθηκών της *R* το οποίο ονομάζεται: **CRAN**, επεκτείνοντας έτσι 
#'  τις δυνατότητες της. Η εξειδίκευση της γλώσσα προγραμματισμού *R* έχει λάβει μεγάλες 
#'  διαστάσεις και μπορεί να ασχοληθεί με μια πληθώρα επιστημονικών προβλημάτων και εφαρμογών.
#' 
#' Ιστορικά
#' ---
#' 
#' * <u>Εμφάνιση</u>: **1993**
#' * <u>Σχεδιασμός</u>: **Ross Ihaka** και **Robert Gentleman**
#' * <u>Ανάπτυξη</u>: **R Development Core Team**
#' * <u>Πλατφόρμα</u>: **Cross-platform**
#' * <u>Άδεια</u>: **GNU General Public Licence**
#' * <u>Ιστοσελίδα</u>: [http://www.r-project.org](http://www.r-project.org)
#' * <u>Έκδοση</u>: **3.1.2 / 31-Οκτ-2014**
#' 
#' Εγκατάσταση
#' ---
#' Η εγκατάσταση της *R* είναι απλή, εκτελώντας τις οδηγίες στους ακόλουθους συνδέσμους:
#'  
#' * Linux: http://cran.r-project.org/bin/linux/
#' * MacOS: http://cran.r-project.org/bin/macosx/
#' * Microsoft Windows: http://cran.r-project.org/bin/windows/
#' 
#' 
#'
#' Βοήθεια
#' ---
#' <ul>
#' <li>Ηλεκτρονικές λίστες: http://www.r-project.org/mail.html</li>
#' <ul>
#'    <li>R-announce</li>
#'    <li>R-packages</li>
#'    <li>R-help</li>
#'    <li>R-devel</li>
#'    <li>Specialized Interest Groups</li>
#' </ul>
#' <li>Συνέδρια: **http://www.r-project.org/conferences.html**</li>
#' <li>Μηχανή αναζήτησης: **http://www.rseek.org**</li>
#' <li>R Journal: **http://journal.r-project.org**</li>
#' </ul>
#' 
#' RStudio
#' ---
#' * Γραφικό περιβάλλον ανάπτυξης (*IDE*) με αυξημένες δυνατότητες: επεξεργασίας, ανάπτυξης, version-control, I/O.
#' * <u>Ανάπτυξη</u>: **RStudio, Inc.**
#' * <u>Πλατφόρμα</u>: **Cross-platform**
#' * <u>Άδεια</u>: **GNU Affero General Public License v3**
#' * <u>Ιστοσελίδα</u>: **http://rstudio.org/**
#' * <u>Έκδοση</u>: **0.98.1091 / 6-Νοε-2014**
#' <img src="Data/RStudio_001.png"  />
#' 


#' Rtools
#' ---
#' 
#' 
#' Στα Windows θα χρειαστεί επιπλέον να εγκαταστήσουμε και το εργαλείο: `RTools` το οποίο βοηθάει στην εγκατάσταση και
#' στο compile κάποιων βιβλιοθηκών.
#'  
#' [https://cran.r-project.org/bin/windows/Rtools/](https://cran.r-project.org/bin/windows/Rtools/)
#' 
#' Βιβλιοθήκες
#' ---
#' 
#' Η γλώσσα `R` μπορεί να επεκταθεί χρησιμοποιώντας επιπλέων βιβλιοθήκες τις οποίες χρειάζεται να κατεβάσουμε μόνο μια φορά.
#' Στη συνέχεια αφού έχουμε κατεβάσει κάποια βιβλιοθήκη, μπορούμε να την φορτώσουμε με την εντολή `library("OnomaBibliothikis")`.
#' 
#' 

#' Δεδομένα
#' ===
#' 
#' Μεταβλητές
#' ---
#' Ορισμός μεταβλητών και πράξεις μεταξύ τους:
x=5
y=10
x+y
x/y
x-y
x*y

#' Παραγωγή δεδομένων ακέραιων αριθμών (integer)
1:10
rep(34,5)
seq(0, 10, 2)

#' Διάνυσμα
#' ---
#' Ορισμός διανυσμάτων (vector) και πράξεις στα στοιχεία τους:
age = c(22,24,26,30,21)
car = c(1,1,0,0,2)
education = c(3,3,3,2,3)
height = c(180,185,190,183,192)

#' Πράξεις σε ένα vector
age * 2
age + 200

#' Πράξεις μεταξύ vector
age * car
age + car

#' Επιλογή στοιχείων
st = c("aa", "bb", "cc", "dd", "ee") 
st[2]
st[1:3]
st[c(1,3,5)]
st[-2]


#' Μέσος όρος vector
mean(age)
#' Πλήθος vector
length(age)



#' data.frame
#' ---
#' Ορισμός πλαίσιου δεδομένων (data.frame), ανάκληση στηλών και περιγραφικά στοιχεία του **data.frame**:
mydata = data.frame(height, age, car, education)
mydata

#' 5 πρώτες γραμμές
head(mydata)

#' Περίληψη των δεδομένων στο data.frame
summary(mydata)

#' Μέγεθος του data.frame
dim(mydata)

#' Ονόματα των στηλών του data.frame
names(mydata)

#' Επιλογή στηλών
mydata$age
mydata$car

#' Πράξεις στηλών
sum(mydata$age)
max(mydata$car)

#' Πλήθος στηλών και γραμμών
nrow(mydata)
ncol(mydata)




#' Λίστα
#' ---
#' Μια λίστα (list) μπορεί να περιλαμβάνει πλήθος ετερόκλητων στοιχείων 
#' όπως: αριθμούς ή/και κείμενο:
mylist=list(height, mydata, "Καλημέρα", "2251036404")
mylist
mylist[1]
mylist[1:2]

#' Βασικές συναρτήσεις
#' ---
#' Το βασικό πακέτο της R (ονομάζεται: `R-Base`) περιλαμβάνει *γενικές* συναρτήσεις 
#' οι οποίες είναι 
#' άμεσα διαθέσιμες και μπορούν να εφαρμοστούν σε ένα 
#' πλήθος τύπων δεδομένων (vector, data.frame, matrix, κτλ):
summary(mydata$age)
mydata$age
min(mydata$age)
max(mydata$age)
mean(mydata$age)
median(mydata$age)
length(mydata$age)
mode(mydata$age)

#' Αναζήτηση βοήθειας
#' ---
#' Για να πάρουμε βοήθεια σχετικά με την χρήση και τα χαρακτηριστικά μιας συνάρτησης, 
#' μπορούμε να καλέσουμε την ακόλουθη εντολή:
help( "summary" ) 
?summary

#' Δομές ροής
#' ---
#' Η δομή **for** επαναλαμβάνει μια σειρά από κώδικα επανειλημμένα εντός ενός ορίου που θέτει ο χρήστης:
x=c(1:10)

for (i in x){
  print( i )
}

for (k in 1:10){
  print( x[k] )
}

for (p in seq(from=10,to=20,by=2)){
  print( p )
}
#' Δοκιμάστε να κάνετε το ίδιο αυξάνοντας συνεχώς το όρισμα *by*:
for (p in seq(from=10,to=20,by=4)){
  print( p )
}

#' Η δομή ροής **if** κάνει λογικό έλεγχο:
y = 15
if (y > 0){
  print("Μεγαλύτερο")
} else {
  print("Μικρότερο")
}

#' Η δομή **if** μπορεί να συνδυαστεί και με την δομή **else** για την διαχείριση περισσότερων ενδεχόμενων καταστάσεων:
for (m in seq(1:10)){
  print(m)
  if (m < 6){
    print("Μικρότερο ή ίσο με 6")
  } else {
    print("Μεγαλύτερο του 6")
  }
}

#' Κατασκευή μεθόδων
x=1:10
kalimera = function(enavector){
  return(enavector * 2)
}

kalimera(x)

#' Αποθήκευση δεδομένων
#' ---
#' Ένα βασικό στοιχείο σε κάθε γλώσσα προγραμματισμού είναι οι δυνατότητες 
#' εισαγωγής και εξαγωγής δεδομένων (Ι/Ο). Η *R* μπορεί αν προσπελάσει 
#' μια πληθώρα από είδη αρχείων και να ανακτήσει τις πληροφορίες που είναι 
#' αποθηκευμένες σε αυτά. Τα είδη των αρχείων που μπορούν να ανακτηθούν 
#' ποικίλουν από απλά ASCII αρχεία τα οποία περιλαμβάνουν αλφαριθμητικούς 
#' χαρακτήρες (κείμενο) έως και τα πλέον σύνθετα και εξειδικευμένα είδη αρχείων.
myt = read.table("Data/mydata.csv", header = T, sep = ",")
myt
write.table(myt, "Data/people.csv", row.names = F, sep=",")

#' Γραφήματα
#' ===
#'
#' Ιστόγραμμα (Histogram)
hist(myt$experience, breaks=5)
hist(myt$experience, breaks=10, main="With 10 bars")

#' Boxplot
boxplot(myt$emails)
boxplot(myt$experience, horizontal=T)

#' Διασποροδιάγραμμα (Scaterplot)
plot(myt$emails)
plot(myt$emails, myt$experience, main="Relationship between emails and\nyears of experience")
cor(myt$emails, myt$experience)


#' Dotplot
dotchart(myt$emails,labels=myt$onoma, main="Emails per person", xlab="Emails")

#' Διατεταγμένο Dotplot με κατηγορίες
x = myt[order(myt$emails),] # sort by emails
x$sex = factor(x$sex) # it must be a factor
x$color[x$sex=="Male"] = "red"
x$color[x$sex=="Female"] = "blue"
dotchart(x$emails,labels=x$onoma,cex=.7, groups= x$sex,main="Emails per person\ngrouped by sex",xlab="emails", color=x$color) 

#' 
plot(myt$emails )
plot(myt$emails, myt$experience )

plot(myt$emails, myt$experience, col=as.factor(myt$sex), pch=19 )
legend("topleft", legend =unique(myt$sex), fill = unique( as.factor(myt$sex)), cex=1 )

boxplot(myt$emails )
boxplot(emails~sex, data = myt, col=c( "cyan","orange"))

pie(table(myt$sex ))


#' Περιγραφική Στατιστική
#' ===
#' 
library(datasets)
data(iris)
df2=iris

#' επισκόπηση
head(df2)
summary(df2)
table(df2$Species)

#' Μέτρα κεντρικής τάσης
#' ---
#' 
mean(df2$Sepal.Length)
median(df2$Sepal.Length)

#' Μέτρα Μεταβλητότητας
#' ---
#' 
min(df2$Sepal.Length)
which.min(df2$Sepal.Length)
max(df2$Sepal.Length)
max(df2$Sepal.Length) - min(df2$Sepal.Length)
range(df2$Sepal.Length)
quantile(df2$Sepal.Length)
quantile(df2$Sepal.Length, seq(0, 1, 0.1))
IQR(df2$Sepal.Length)
median(df2$Sepal.Length)
mad(df2$Sepal.Length) # Median Absolute Deviation

quantile(df2$Sepal.Length )

var(df2$Sepal.Length) # διασπορά
sd(df2$Sepal.Length) # τυπική απόκληση

#' Συντελεστής μεταβλητότητα
mycv = function(x) {
  return( sd(x) / mean(x) ) 
}
mycv(df2$Sepal.Length)


#' Περιλήψεις
#' ---
#' 
summary(df2$Sepal.Length)
summary(df2, digits = 1)
sapply(df2[, -5], mean) # Mean by column
sapply(df2[, -5], quantile) # Quartiles




#' Στατιστικά ανά ομάδες
#' ---
#' 
library("dplyr")

df2 %>% group_by(Species) %>% 
  summarise(
    count = n(), 
    mean = mean(Sepal.Length, na.rm = TRUE),
    sd = sd(Sepal.Length, na.rm = TRUE)
  )


library("ggpubr")
#' Box plot colored by groups: Species
ggboxplot(df2, x = "Species", y = "Sepal.Length",
          color = "Species",
          palette = c("#00AFBB", "#E7B800", "#FC4E07"))


#' Stripchart colored by groups: Species
ggstripchart(df2, x = "Species", y = "Sepal.Length",
             color = "Species",
             palette = c("#00AFBB", "#E7B800", "#FC4E07"),
             add = "mean_sd")


#' Συχνότητες
#' ---
#' 
df3 = as.data.frame(HairEyeColor)
hair_eye_col = df3[rep(row.names(df3), df3$Freq), 1:3]
rownames(hair_eye_col) = 1:nrow(hair_eye_col)
head(hair_eye_col)

#' hair/eye variables
Hair = hair_eye_col$Hair
Eye = hair_eye_col$Eye

#' Frequency distribution of hair color
table(Hair)
#' Frequency distribution of eye color
table(Eye)


#' Πίνακας διπλής εισόδου
#' ---
#' 
#' 2 κατηγορικές μεταβλητές
#' 
tbl2 = table(Hair , Eye)
tbl2
xtabs(~ Hair + Eye, data = hair_eye_col)

df4 = as.data.frame(tbl2)
head(df4)

#' Οπτικοποίηση με bar plot
library(ggpubr)
ggbarplot(df4, x = "Hair", y = "Freq",
          color = "Eye", 
          palette = c("brown", "blue", "gold", "green"))


#' position dodge
ggbarplot(df4, x = "Hair", y = "Freq",
          color = "Eye", position = position_dodge(),
          palette = c("brown", "blue", "gold", "green"))


#' Συχνότητες Β' μέρος
#' ---
#' 
#' 
Hair = hair_eye_col$Hair
Eye = hair_eye_col$Eye
# Hair/Eye color table
he.tbl = table(Hair, Eye)
he.tbl

#' margin: index number (1 γραμμές και 2 για στήλες)
#' 
#' Margin of rows
margin.table(he.tbl, 1)
#' Margin of columns
margin.table(he.tbl, 2)

#' Σχετικές συχνότητες:
#' Frequencies relative to row total
prop.table(he.tbl, 1)

#' Table of percentages
round(prop.table(he.tbl, 1), 2)*100


#' Express the frequencies relative to the grand total:
he.tbl/sum(he.tbl) * 100


#' Γραμμική Παλινδρόμηση
#' ---
#' 
library(readxl)
df5 = read_excel("Data/Data.xls")

df5

#' Boxplot
library(ggplot2)
ggplot(stack(df5), aes(x = ind, y = values)) + geom_boxplot()


model1 = lm(ena ~ duo+tria  , data=df5)  # build linear regression model on full data
print(summary(model1))

# ena = -5.2 + (0.15 * duo) + (-5.47 * tria)

par(mfrow=c(2,2)) # Change the panel layout to 2 x 2
plot(model1)
par(mfrow=c(1,1)) # Change back to 1 x 1

plot(df5$ena, df5$duo)
abline(lm(df5$duo ~ df5$ena), col="blue", lwd=2)

#' Διαγνωστικά
#' ---
#' 
library(tidyverse)
library(broom)
model.diag.metrics = augment(model1)
head(model.diag.metrics)


library(ggfortify)
autoplot(model1)



library(jtools)
summ(model1)
summ(model1, confint = TRUE, digits =2) # confidence intervals

effect_plot(model1, pred = duo, interval = TRUE, plot.points = TRUE)
effect_plot(model1, pred = tria, interval = TRUE, plot.points = TRUE)

plot_summs(model1, scale = T)
plot_summs(model1, scale = TRUE, plot.distributions = TRUE, inner_ci_level = .9)

fit2 = lm(ena ~ duo, data =df5)
plot_summs(model1, fit2, scale = TRUE)
plot_summs(model1, fit2, scale = TRUE, plot.distributions = TRUE)
plot_summs(model1, model1, model1, scale = TRUE, robust = list(FALSE, "HC0", "HC3"),
           model.names = c("OLS", "HC0", "HC3"))


 




#' Γεωγραφικά Δεδομένα
#' ===
#' 

#' Υπάρχει μια πληθώρα από βιβλιοθήκες που σχετίζονται με γεωγραφικά δεδομένα. Έχουν κατηγοριοποιηθεί και τυποποιηθεί από τον **Roger Bivand** 
#' και βρίσκονται στον ακόλουθο σύνδεσμο: http://cran.r-project.org/web/views/Spatial.html 
#' 
#' * Classes for spatial data
#' * Handling spatial data
#' * Reading and writing spatial data 
#' * Point pattern analysis
#' * Geostatistics
#' * Αreal data analysis
#' * Spatial regression
#' * Ecological analysis
#' 
#' 

#' Εισαγωγή χωρικών δεδομένων
#' ---
#' 
#' Το αρχείο **"Shapefiles/Lesvos"** περιλαμβάνει δεδομένα για τις 
#' περιοχές της Λέσβου. Πριν εισάγουμε τα δεδομένα, φορτώνουμε τις απαραίτητες βιβλιοθήκες:
#+ message=F, warning=F
library(rgeos)
library(maptools)
library(rgdal)
le=rgdal::readOGR("Data/Lesvos.shp" )
proj4string(le) = CRS("+init=epsg:2100") # Greek Grid: ΕΓΣΑ: Εθνικό Γεωδαιτικό Σύστημα Αναφοράς




#' 
#' <img src="Data/shapefile.png" />
#' 
#' Η μεταβλητή __le__ είναι αντικείμενο (objet) της μορφής: __SpatialPolygonDataFrame__ και 
#' περιλαμβάνει τα ακόλουθα ενθυλακωμένα αντικείμενα (encapsulated objects). 
#' Κάθε φορά που χειριζόμαστε ένα τέτοιο αντικείμενο, μπορούμε να έχουμε πρόσβαση 
#' και στα επιμέρους στοιχεία του τα οποία απεικονίζονται στην παραπάνω εικόνα.



#' Αφού φορτώθηκαν τα δεδομένα με επιτυχία, τώρα μπορούμε να διερευνήσουμε τα επιμέρους αντικείμενα του **le**:
slotNames(le)
le@data
le@bbox
le@proj4string
summary(le)
coordinates(le)


#' Διερεύνηση
#' ---
#' 
#' Μπορούμε να επεξεργαστούμε τα δεδομένα του __shapefile__ και να 
#' δημιουργήσουμε νέες στήλες που θα περιλαμβάνουν δεδομένα για κάθε 
#' γεωγραφική περιοχή. Για να προσπελάσουμε τα δεδομένα του __shapefile__ εκτελούμε __le\@data__. 
#' Προσέξτε οτι για να αποκτήσουμε πρόσβαση σε υπο-αντικείμενο της κλάσης __SpatialPolygonsDataFrame__ 
#' χρησιμοποιήσαμε τον τελεστή __\@__ και όχι τον τελεστή __$__ που χρησιμοποιούμε προηγουμένως για την προσπέλαση 
#' υπο-αντικειμένων σε κάποιο __data.frame__.
le@data 
le@data$cars
le@data$villages
le@data$type
table(le@data$type)

#' Η συνάρτηση **spsample** παράγει σημεία εντός μιας περιοχής. 
#' Έτσι για την δημιουργία σημείων (τυχαία, κανονικοποιημένα, ασύμμετρα και 
#' σε εξάγωνη διάταξη) εντός του νησιού, εκτελούμε:
mypoints_ran = spsample(le, n=100, type='random')
mypoints_reg = spsample(le, n=100, type='regular')
mypoints_non = spsample(le, n=100, type='nonaligned')
mypoints_hex = spsample(le, n=100, type='hexagonal')

#' Ο παρακάτω κώδικας απεικονίζει και 4 είδη σημείων που μόλις παρήχθησαν:
#+ message=F, warning=F
par(mfrow=c(2,2))

plot(le, main="Random")
points(mypoints_ran, col="red", pch=16)

plot(le, main="Stratified")
points(mypoints_reg, col="red", pch=16)

plot(le, main="Nonaligned")
points(mypoints_non, col="red", pch=16)

plot(le, main="Hexagonal")
points(mypoints_hex, col="red", pch=16)

par(mfrow=c(1,1))

#' Για να δούμε περισσότερες λεπτομέρειες σχετικά με την 
#' συνάρτηση **spsample**, εκτελούμε τον παρακάτω κώδικα:
?spsample

#' Δημιουργία μιας νέας στήλης με νέων τιμές.
#' Για να δούμε ποιο είναι η σχέση πληθυσμού με αυτοκίνητα, 
#' διαιρούμε το πληθυσμό της κάθε περιοχής με το πλήθος των αυτοκινήτων. 
#' Το νούμερο που θα προκύψει, δείχνει το αριθμό αυτοκινήτων 
#' ανά κάτοικο για κάθε περιοχή:
le@data$ratio_cars =  le@data$cars / le@data$pop 
le@data


#' Επίσης για να δημιουργήσουμε άλλον ένα δείκτη που να φανερώνει 
#' την _σχέση πληθυσμού_ ανά _ποσότητα χωριών_ για **κάθε περιοχή**, 
#' εκτελούμε τον ακόλουθο κώδικα ο οποίος αναθέτει τα αποτελέσματα του δείκτη σε μια νέα στήλη με το όνομα **ratio_villages**:
le@data$ratio_villages =   le@data$villages / le@data$pop 
le@data


#' Βιβλιοθήκες
#' ---
#' 
#' Η γλώσσα προγραμματισμού R επεκτείνετε με την χρήση επιπλέον 
#' βιβλιοθηκών οι οποίες προσθέτουν επιπλέον δυνατότητες και συναρτήσεις. 
#' Οι βιβλιοθήκες περιλαμβάνουν εξειδικευμένες δυνατότητες σχετικές με διάφορες επιστήμες.
#'  Έτσι για παράδειγμα για την χρήση γεωγραφικών δεδομένων μπορούμε να εγκαταστήσουμε 
#'  και στην συνέχεια να καλέσουμε την βιβλιοθήκη **maptools** η οποία προσφέρει στην 
#'  R την δυνατότητα ανάκτησης, διαχείρισης και αποθήκευσης δεδομένων γεωγραφικού 
#'  τύπου όπως πχ **shapefiles**. Το ακόλουθο παράδειγμα αναδεικνύει την εγκατάσταση, 
#'  κλήση και χρήση της βιβλιοθήκης **rgdal** 
#' για την ανάκτηση/αποθήκευση ενός αρχείου τύπου **shapefile**.

#+ eval=F
# install.packages("maptools", dep=T) 
# install.packages("rgdal", dep=T)
# library(maptools)
# library(rgdal)
# 
# mydata = rgdal::readOGR("myfile.shp")
# rgdal::writeOGR(mydata,"anewname", "anewname.shp", driver="ESRI Shapefile")




  
#' Οπτικοποίηση
#' ---
#' 
#+ message=F, warning=F 
library(rgdal)
library(RColorBrewer)
library(MASS)
library(GISTools)
library(classInt)
library(maptools)
library(maps)

#' Απλή απεικόνιση των πολυγώνων
plot(le)

#' Απεικόνιση των πολυγώνων με πορτοκαλί χρώμα και γαλάζιο χρώμα στο παρασκήνιο:
plot(le, col="orange", bg="cyan")

#' Κατασκευή απλού χάρτη του νησιού με βάση 4 πληθυσμιακές κατηγορίες:
#+ message=F, warning=F
library(RColorBrewer)
library(classInt)
library(maptools)
library(rgdal)
nclasses = 4
mycolors = brewer.pal(nclasses, "YlOrRd")
brks = classIntervals(le@data$pop, n=nclasses, style="quantile")
brks = brks$brks
plot(le, col=mycolors[findInterval(le@data$pop, brks,all.inside=T)], axes=F)
title( "Λέσβος" )
legend("bottomleft", legend=rev(leglabs(round(brks))),  title= "Υπόμνημα", fill=rev(mycolors))



#' Join
#' ---
#' 
#' Τα αρχικά δεδομένα από το *Shapefile* μας είναι τα ακόλουθα:
le@data

#' Σε αυτά τα δεδομένα, θα προσπαθήσουμε να 
#' επισυνάπτουμε άλλη μια επιπλέον στήλη, η οποία προσδιορίζει το 
#' όνομα της κάθε γεωγραφικής περιοχής. Τα ονόματα βρίσκονται σε 
#' ένα αρχείο __.csv__ το οποίο εισάγουμε στην __R__ και στην συνέχεια 
#' επικολλούμε με τα δεδομένα του Shapefile χρησιμοποιώντας την κοινή στήλη __id__.
onomata = read.csv("Data/onomata.csv")
onomata
if (!("onoma" %in% names(le@data))) {
  temp = merge(le@data, onomata, by="id", sort=FALSE)
  le@data = temp
}
le@data
le@data$onoma = as.character(le@data$onoma)
rgdal::writeOGR(le,"Lesvos_Joined","Lesvos_Joined.shp", driver="ESRI Shapefile", overwrite=T)

#+ warning=F
plot(le, col = mycolors[findInterval(le@data$pop, brks, all.inside = TRUE)], axes = F)
cen = coordinates(le)
text(cen, le@data$onoma, cex=0.8)


#' Τα κεντροειδή μπορούν να χρησιμοποιηθούν και ξεχωριστά από το **shapefile** ακόμα 
#' και να εξαχθούν σε ένα αυτόνομο shapefile που θα περιλαμβάνει σημεία.
#' 
#+ message=F, warning=F
plot(le)
points(cen, cex=2, col="red")

cen2 = SpatialPoints(cen)
cen3 = SpatialPointsDataFrame(cen2, data=data.frame(cen2))
rgdal::writeOGR(cen3,"centroids","centroids.shp", driver="ESRI Shapefile", overwrite=T)



#' Quadrat Count Analysis 2 διαφορετικών χωρικών δειγμάτων. 
#' Ενός _τυχαίου_ και ενός _κανονικοποιημένου_ σε εξαγωνική διάταξη.
library(spatstat)
perioxi = le[le@data$onoma=="Περιοχή ΕΕ",]

#' Παραγωγή 70 σημείων εντός της ευρύτερης περιοχής
n=70
mysample1 = as( spsample(perioxi, n=n, type='hexagonal'), "ppp")
mysample2 = as( spsample(perioxi, n=n, type='random'), "ppp")
plot(le)
plot(perioxi, add=T, col="red")

#' Κανονικοποιημένη εξαγωνική διάταξη
qc1 = quadratcount(mysample1, nx=10)
plot(perioxi)
#image( intensity(qc1, image=T), col = heat.colors(10,alpha = 0.5),  add = T)
points(mysample1, cex=0.5, col="darkgrey")
plot(qc1, add=T, col="brown", cex=1, lty=3)

#' Τυχαία διάταξη
qc2 = quadratcount(mysample2, nx=10)
plot(perioxi)
#image( intensity(qc2, image=T), col = heat.colors(10,alpha = 0.5),  add = T)
points(mysample2, cex=0.5, col="darkgrey")
plot(qc2, add=T, col="brown", cex=1, lty=3)


 

#' Βιβλιοθήκη _spatstat_
#' ---
#' 
plot(perioxi)
points(mysample2, pch=20)
summary(mysample2)

#' Υπολογισμός της _απόστασης_ του πλησιέστερου γείτονα για όλα τα σημεία
nearest = nndist(mysample2)
summary(nearest)
sd(nearest)
hist(nearest, col="green")


#' Υπολογισμός του πλησιέστερου γείτονα για όλα τα σημεία.
m = nnwhich(mysample2)
m2 = nnwhich(mysample2, k=2)

#' Οπτικοποίηση του πλησιέστερου γείτονα για κάθε σημείο.
b = mysample2[m]
plot(mysample2)
arrows(mysample2$x, mysample2$y, b$x, b$y, angle=15, length=0.15, col="red")


#' Διάγραμμα πυκνότητας
plot(density(mysample2, 10))
plot(density(mysample2, 100))
plot(density(mysample2, 1000))
points(mysample2, pch=20)

#' Διάγραμμα ισό-πυκνων καμπυλών
contour(density(mysample2,10), axes=FALSE)
contour(density(mysample2,100), axes=FALSE)
contour(density(mysample2,1000), axes=FALSE)
points(mysample2, pch=20)



